//
//  WDAuthorizedTask.h
//  Installer
//
//  Created by Clark Jackson on 12/9/10.
//  Copyright 2013 Western Digital Technologies, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

APPKIT_EXTERN NSString* const WDSyncAppSupportFolderKey;
APPKIT_EXTERN NSString* const WDZippedResourcesNameKey;



typedef enum WDDaemonType
{
    kWDSmartWareServer = 0,
    kMemeod = 1, 
    kWDDM = 2,
    kWDSyncServices = 3,
}
WDDaemonType;


@protocol AppDelegateProtocol<NSObject>

- (BOOL) bypassAuthorizationDialogFlag;
- (NSString*) scriptedUserName;
- (NSString*) scriptedPassword;

@end

#define kSyncServiceBundleIdentifier "com.wdc.WD-Sync-Service"


@interface WDAuthorizedTask : NSObject<AppDelegateProtocol>
{
	BOOL fInstall;
    BOOL osAuthorizationIsCancelled;
    
	int installIndex;
    
	AuthorizationRef authorizationRef;
    
	NSString* tmpCopyToolPath;
    NSString* tmpInstallFolder;
    NSString* componentParameter;
    NSString* parent;
    
	NSArray* removePaths;
    NSArray* legacyRemovePaths;
    NSArray* parameterArray;
    
	NSArray* billOfMaterialsInstallFromPaths;
    NSArray* billOfMaterialsInstallToPaths;
    
    NSString* output;
    NSString* zippedResourcesName;
    NSString* applicationSupportFolderName;
}

@property (readwrite, retain) NSString* tmpInstallFolder, *tmpCopyToolPath, *parent,*componentParameter;
@property (readwrite, retain) NSArray* removePaths, *legacyRemovePaths, *parameterArray;
@property (readwrite, assign) BOOL osAuthorizationIsCancelled;
@property (readwrite, retain) NSArray* billOfMaterialsInstallFromPaths, *billOfMaterialsInstallToPaths;
@property (readwrite, assign) int installIndex;
@property (readwrite, copy) NSString* output;
@property (readwrite, copy) NSString* zippedResourcesName;
@property (readwrite, copy) NSString* applicationSupportFolderName;

#pragma mark ------- Initialization and Setup ------- 

- (void) copyResourcesFromStorageDevice:(NSString *)storageDeviceSoftwarePath; //Ganesh - Added for reading the resources from a storage device
- (void) copyResourcesFromStorageDevicePrivateShare; 
- (void) copyResourcesToHomeDirectoryLaunchd;
- (void) unzipFilesInPath:(NSString *)dirPath;

#pragma mark ------- Authorization & NSTask Methods ------- 
- (void) activate;
- (OSStatus) preauthorizeForRight;
- (NSData *) authorizationAsData;
- (NSTask *) taskForExecutable:(NSString *)execPath arguments:(NSArray *)args;
- (IBAction)runScript:(NSString*)scriptString withArguments:(NSArray*) arguments;
- (void) launchSelfContainedNSTask:(int)typeOfLaunch;

#pragma mark ------- Inventory ------- 
- (NSMutableArray *) installedKEXTs;
- (NSMutableArray *) installed64KEXTs;
- (NSMutableArray *) missingComponents;


@end
